/*
 * Decompiled with CFR 0.152.
 */
package jade.content.frame;

import jade.content.frame.Frame;
import jade.content.frame.FrameException;
import jade.content.frame.OrderedFrame;
import jade.content.frame.QualifiedFrame;
import jade.content.lang.sl.SimpleSLTokenizer;
import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ISO8601;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.util.Date;
import java.util.Enumeration;

public class SLFrameCodec
implements Serializable {
    public static final String NAME = "FIPA-SL";

    public String encode(Frame content) throws FrameException {
        if (content == null) {
            return null;
        }
        try {
            StringBuffer sb = new StringBuffer();
            this.write(sb, content);
            return sb.toString();
        }
        catch (FrameException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FrameException("Error encoding content", t);
        }
    }

    public Frame decode(String content) throws FrameException {
        if (content == null || content.length() == 0) {
            return null;
        }
        try {
            return (Frame)this.read(new SimpleSLTokenizer(content));
        }
        catch (FrameException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FrameException("Error decoding content", t);
        }
    }

    private void write(StringBuffer sb, Object obj) throws Throwable {
        if (obj instanceof AID) {
            obj = this.aidToFrame((AID)obj);
        }
        if (obj instanceof QualifiedFrame) {
            this.writeQualified(sb, (QualifiedFrame)obj);
        } else if (obj instanceof OrderedFrame) {
            this.writeOrdered(sb, (OrderedFrame)obj);
        } else if (obj instanceof Date) {
            sb.append(ISO8601.toString((Date)obj));
        } else if (obj instanceof Integer || obj instanceof Long || obj instanceof Boolean) {
            sb.append(obj);
        } else if (obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            sb.append('#');
            sb.append(b.length);
            sb.append('\"');
            sb.append(new String(b));
            sb.append('\"');
        } else if (obj instanceof String) {
            String s = (String)obj;
            if (CaseInsensitiveString.equalsIgnoreCase("true", s) || CaseInsensitiveString.equalsIgnoreCase("false", s)) {
                s = '\"' + s + '\"';
            } else if (!SimpleSLTokenizer.isAWord(s)) {
                s = SimpleSLTokenizer.quoteString(s);
            }
            sb.append(s);
        } else {
            throw new FrameException("Can't encode " + obj + " of class " + obj.getClass().getName());
        }
    }

    private void writeQualified(StringBuffer sb, QualifiedFrame qf) throws Throwable {
        sb.append('(');
        sb.append(qf.getTypeName());
        Enumeration e = qf.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            sb.append(" :");
            sb.append(key);
            sb.append(' ');
            this.write(sb, qf.get(key));
        }
        sb.append(')');
    }

    private void writeOrdered(StringBuffer sb, OrderedFrame of) throws Throwable {
        sb.append('(');
        sb.append(of.getTypeName());
        Enumeration e = of.elements();
        while (e.hasMoreElements()) {
            sb.append(' ');
            this.write(sb, e.nextElement());
        }
        sb.append(')');
    }

    private Object read(SimpleSLTokenizer st) throws Throwable {
        if (st.nextToken().equals("(")) {
            st.consumeChar('(');
            String typeName = st.getElement();
            if (st.nextToken().startsWith(":")) {
                QualifiedFrame qf = new QualifiedFrame(typeName);
                this.fillQualified(st, qf);
                if (qf.getTypeName().equals("agent-identifier")) {
                    return this.frameToAid(qf);
                }
                return qf;
            }
            OrderedFrame of = new OrderedFrame(typeName);
            this.fillOrdered(st, of);
            return of;
        }
        String val = st.getElement();
        try {
            return new Long(Long.parseLong(val));
        }
        catch (Exception e) {
            try {
                return ISO8601.toDate(val);
            }
            catch (Exception e2) {
                if (val.equals("true")) {
                    return new Boolean(true);
                }
                if (val.equals("false")) {
                    return new Boolean(false);
                }
                return val;
            }
        }
    }

    private void fillQualified(SimpleSLTokenizer st, QualifiedFrame qf) throws Throwable {
        while (!st.nextToken().equals(")")) {
            String key = st.getElement();
            Object val = this.read(st);
            qf.put(key, val);
        }
        st.consumeChar(')');
    }

    private void fillOrdered(SimpleSLTokenizer st, OrderedFrame of) throws Throwable {
        while (!st.nextToken().equals(")")) {
            of.addElement(this.read(st));
        }
        st.consumeChar(')');
    }

    private final QualifiedFrame aidToFrame(AID id) {
        QualifiedFrame f = new QualifiedFrame("agent-identifier");
        f.put("name", id.getName());
        Iterator i = id.getAllAddresses();
        if (i.hasNext()) {
            OrderedFrame addresses = new OrderedFrame("sequence");
            while (i.hasNext()) {
                addresses.addElement(i.next());
            }
            f.put("addresses", addresses);
        }
        if ((i = id.getAllResolvers()).hasNext()) {
            OrderedFrame resolvers = new OrderedFrame("sequence");
            while (i.hasNext()) {
                AID res = (AID)i.next();
                resolvers.addElement(this.aidToFrame(res));
            }
            f.put("resolvers", resolvers);
        }
        return f;
    }

    private final AID frameToAid(QualifiedFrame f) {
        OrderedFrame resolvers;
        AID id = new AID((String)f.get("name"), true);
        OrderedFrame addresses = (OrderedFrame)f.get("addresses");
        if (addresses != null) {
            int i = 0;
            while (i < addresses.size()) {
                id.addAddresses((String)addresses.elementAt(i));
                ++i;
            }
        }
        if ((resolvers = (OrderedFrame)f.get("resolvers")) != null) {
            int i = 0;
            while (i < resolvers.size()) {
                AID res = this.frameToAid((QualifiedFrame)resolvers.elementAt(i));
                id.addResolvers(res);
                ++i;
            }
        }
        return id;
    }
}

